﻿/*  Author:     Ben Hall
 *  File:       MainPage.Chat.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    MainPage.Chat.cs is a partial class that contains the code needed for handling the program's
 *              chat system.  Since the chat system is only used currently for combat logs and system messages,
 *              there is little code here.
 */

using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace OnlineGame
{
    //Implements Chat features of MainPage
    public partial class MainPage
    {
        private static Color systemMessageColor = Colors.Black;
        private static Color zoneMessageColor = Colors.Green;
        private static Color partyMessageColor = Colors.Cyan;
        private static Color privateMessageColor = Colors.Purple;
        private static Color combatMessageColor = Colors.Red;

        /*  SendTypedMessage() currently sends the typed message in the ChatBox to the chat
         *  area.
         *  When a chat system is implemented, this method will send typed messages to the server
         *  to send to other players.
         */
        private void SendTypedMessage()
        {
            String chatText = ChatBox.Text;
            
            if (!(chatText.Length == 0))
            {
                AddMessageToChatBox(chatText, Colors.Black);
            }
        }

        /*  AddMessageToChatBox() adds a TextBox object to the ChatMessages object, with the given
         *  string as the message, and a given color.
         */
        public void AddMessageToChatBox(String messageIn, Color colorIn)
        {
            TextBox message = new TextBox();
            message.Text = messageIn;
            message.Width = ChatMessages.Width;
            message.TextWrapping = TextWrapping.Wrap;

            message.Background = new SolidColorBrush(Colors.White);
            message.Background.Opacity = 0.0;
            message.IsReadOnly = true;
            //USE THIS WITH DIFFERENT CHAT TYPES (ZONE, PARTY, ETC)
            message.Foreground = new SolidColorBrush(colorIn);
            message.BorderBrush = new SolidColorBrush(Colors.Transparent);
            ChatMessages.Children.Add(message);
            ChatBox.Text = "";
            ChatViewer.UpdateLayout();
            ChatViewer.ScrollToVerticalOffset(ChatMessages.ActualHeight);
        }

                                /* CHAT EVENTS */
        /*  ChatSendButton_Click() makes a call to SendTypedMessage() and gives the ChatBox focus.
         */
        private void ChatSendButton_Click(object sender, RoutedEventArgs e)
        {
            SendTypedMessage();
            ChatBox.Focus();
        }

        /*  ChatEnter() makes a call to SendTypedMessage() when the enter key is pressed in the ChatBox
         */
        private void ChatEnter(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                SendTypedMessage();
            }
        }

    }
}
